// FloralTheme.tsx
import React, { useMemo } from 'react';
import "@/context/themes/floral theme.css";

interface FloralThemeProps {
  mode?: "light" | "dusky"; // 'dusky' can represent our dark mode
}

const FloralTheme: React.FC<FloralThemeProps> = ({ mode = "light" }) => {
  // Updated image paths to use new wisteria images
  const headerImages = useMemo(() => [
    "/images/Elements/wisteriaheader.png"
  ], []);

  const mainBackgroundImageHints = useMemo(() => [
    "/images/Elements/wisteriabg.png"
  ], []);

  const sidebarImages = useMemo(() => [
    "/images/Elements/wisteriasidebar.png"
  ], []);

  // For decorative frames
  const frameDecorationImages = useMemo(() => [
    "/images/RoyaltyFree/royal purple china.webp",
    "/images/RoyaltyFree/pink dusty macaron.png",
    "/images/RoyaltyFree/tulips lavender nick115.jpg",
    "/images/RoyaltyFree/blushing blossoms peggychoucair.jpg",
    "/images/RoyaltyFree/rose petals.png",
    "/images/RoyaltyFree/roses few.png",
    "/images/RoyaltyFree/tangerine leaf border.jpg",
    "/images/RoyaltyFree/eucalypt border.jpg",
    "/images/RoyaltyFree/watercolour leaves border.jpg",
  ], []);

  const selectedHeaderImage = useMemo(() => headerImages[0], [headerImages]);
  const selectedMainBackgroundImageHint = useMemo(() => mainBackgroundImageHints[0], [mainBackgroundImageHints]);
  const selectedSidebarImage = useMemo(() => sidebarImages[0], [sidebarImages]);
  const selectedFrameDecorationImage = useMemo(() => frameDecorationImages[Math.floor(Math.random() * frameDecorationImages.length)], [frameDecorationImages]);
  const selectedFrameFullBorderImage = useMemo(() => frameDecorationImages[Math.floor(Math.random() * frameDecorationImages.length)], [frameDecorationImages]);

  // Placeholder for navigation items
  const navItems = [
    { name: "FloralTheme A", path: "/annepie/floralthemeA" },
    { name: "FloralTheme B", path: "/annepie/floralthemeB" },
    { name: "FloralTheme C", path: "/annepie/floralthemeC" },
    { name: "FloralTheme D", path: "/annepie/floralthemeD" },
    { name: "FloralTheme E", path: "/annepie/floralthemeE" },
  ];

  return (
    <div
      className={`floral-theme-container ${mode}`}
      style={{ backgroundImage: `url(${selectedMainBackgroundImageHint})` }}
    >
      <header className="floral-header">
        <img src={selectedHeaderImage} alt="Wisteria Header" className="floral-header-image" />
        <div className="floral-header-overlay">
          <h1 className="floral-site-title">Annepie.com</h1>
          <nav className="floral-navigation">
            {navItems.map(item => (
              <a key={item.name} href={item.path} className="floral-nav-link">{item.name}</a>
            ))}
          </nav>
        </div>
      </header>

      <div className="floral-body-wrapper">
        <div className="floral-content">
          <aside
            className="floral-sidebar"
            style={{ backgroundImage: `url(${selectedSidebarImage})` }}
          >
            <p><strong>Path:</strong></p>
            <ul className="floral-sidebar-path">
              <li><a href="#video1">Video 1</a></li>
              <li><a href="#video1a">Video 1a</a></li>
              <li><a href="#video2">Video 2</a></li>
            </ul>
            <p>More sidebar content...</p>
          </aside>

          <main className="floral-main">
            <h2>Welcome to the Garden</h2>
            <p>This theme is a quiet path through blossoms, with soft morning light and floral comfort.</p>

            <div className="floral-decorative-frame floral-video-frame-example">
              <div className="floral-frame-decoration-top" style={{backgroundImage: `url(${selectedFrameDecorationImage})`}}></div>
              <div className="floral-frame-content">
                <p>Video or other content goes here (top/bottom frame)</p>
              </div>
              <div className="floral-frame-decoration-bottom" style={{backgroundImage: `url(${selectedFrameDecorationImage})`}}></div>
            </div>

            <div 
              className="floral-decorative-frame floral-full-border-frame-example"
              style={{ backgroundImage: `url(${selectedFrameFullBorderImage})` }}
            >
              <div className="floral-frame-content">
                <p>Text box with full image border</p>
              </div>
            </div>

            <div className="floral-decorative-frame floral-circular-frame-example">
                <div className="floral-frame-content floral-circular-content">
                    <p>Icon</p>
                </div>
            </div>
          </main>
        </div>
      </div>
    </div>
  );
};

export default FloralTheme;
